
## Layer 3 Data Plane Security Features

- Layer 3 network devices provide security features to protect against Layer 3 attacks.

---

### Key Security Features

#### 1. Traffic Filtering Features

- Use of Access Control Lists (ACLs) to:
    - Filter traffic based on packet header information (source/destination IP, port, protocol, flags).
    - Limit access to network devices and endpoints.
    - Prevent device compromise.

#### 2. Antispoofing Controls

- Prevent identity theft and block malicious traffic using:
    - **ACLs**
    - **Unicast Reverse Path Forwarding (uRPF)**
        - Blocks traffic from invalid or private source addresses.
        - Reduces IP address spoofing used in DoS, DDoS, and network scans.
        - Defined in RFC 3704 and RFC 8704.
    - **IP Source Guard**
        - Source IP filtering on Layer 2 ports.
        - Prevents hosts from impersonating legitimate IP addresses.
        - Uses dynamic DHCP snooping and static IP bindings to verify host identity.
        - Only DHCP packets are initially allowed; other traffic permitted after proper IP address assignment.

---

### Additional Controls

- **Access Control Policy**
    - Similar to ACLs but can also filter based on:
        - Source and destination networks.
        - Protocols and port numbers.
        - Layer 7 application protocols.
        - Detailed payloads, such as specific URLs.